USE [EleriumClean]
GO

/****** Object:  Table [dbo].[StoreExchangeRate]    Script Date: 10/3/2013 8:15:58 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[StoreExchangeRate](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StoreCurrencyID] [int] NULL,
	[DateCreated] [datetime] NULL,
	[DateModified] [datetime] NULL,
	[Date] [date] NOT NULL,
	[Rate] [money] NOT NULL,
 CONSTRAINT [PK_StoreExchangeRate] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[StoreExchangeRate] ADD  CONSTRAINT [DF_StoreExchangeRate_DateCreated]  DEFAULT (getutcdate()) FOR [DateCreated]
GO

ALTER TABLE [dbo].[StoreExchangeRate] ADD  CONSTRAINT [DF_StoreExchangeRate_DateModified]  DEFAULT (getutcdate()) FOR [DateModified]
GO

ALTER TABLE [dbo].[StoreExchangeRate]  WITH CHECK ADD  CONSTRAINT [FK_StoreExchangeRate_StoreCurrency] FOREIGN KEY([StoreCurrencyID])
REFERENCES [dbo].[StoreCurrency] ([ID])
GO

ALTER TABLE [dbo].[StoreExchangeRate] CHECK CONSTRAINT [FK_StoreExchangeRate_StoreCurrency]
GO


